/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core;

import com.google.common.base.Preconditions;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nullable;
import org.sonarsource.sonarlint.core.client.api.common.LogOutput;
import org.sonarsource.sonarlint.core.client.api.common.RuleDetails;
import org.sonarsource.sonarlint.core.client.api.common.SonarLintWrappedException;
import org.sonarsource.sonarlint.core.client.api.common.analysis.AnalysisResults;
import org.sonarsource.sonarlint.core.client.api.common.analysis.IssueListener;
import org.sonarsource.sonarlint.core.client.api.standalone.StandaloneAnalysisConfiguration;
import org.sonarsource.sonarlint.core.client.api.standalone.StandaloneGlobalConfiguration;
import org.sonarsource.sonarlint.core.client.api.standalone.StandaloneSonarLintEngine;
import org.sonarsource.sonarlint.core.container.standalone.StandaloneGlobalContainer;
import org.sonarsource.sonarlint.core.log.SonarLintLogging;

public final class StandaloneSonarLintEngineImpl
implements StandaloneSonarLintEngine {
    private final StandaloneGlobalConfiguration globalConfig;
    private StandaloneGlobalContainer globalContainer;
    private final ReadWriteLock rwl = new ReentrantReadWriteLock();
    private LogOutput logOutput = null;

    public StandaloneSonarLintEngineImpl(StandaloneGlobalConfiguration globalConfig) {
        this.globalConfig = globalConfig;
        this.logOutput = globalConfig.getLogOutput();
        this.start();
    }

    public StandaloneGlobalContainer getGlobalContainer() {
        return this.globalContainer;
    }

    public void start() {
        this.setLogging(null);
        this.rwl.writeLock().lock();
        this.globalContainer = StandaloneGlobalContainer.create(this.globalConfig);
        try {
            this.globalContainer.startComponents();
        }
        catch (RuntimeException e) {
            throw SonarLintWrappedException.wrap((Throwable)e);
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    public RuleDetails getRuleDetails(String ruleKey) {
        this.setLogging(null);
        this.rwl.readLock().lock();
        try {
            RuleDetails ruleDetails = this.globalContainer.getRuleDetails(ruleKey);
            return ruleDetails;
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    public AnalysisResults analyze(StandaloneAnalysisConfiguration configuration, IssueListener issueListener) {
        return this.analyze(configuration, issueListener, null);
    }

    public AnalysisResults analyze(StandaloneAnalysisConfiguration configuration, IssueListener issueListener, @Nullable LogOutput logOutput) {
        Preconditions.checkNotNull(configuration);
        Preconditions.checkNotNull(issueListener);
        this.setLogging(logOutput);
        this.rwl.readLock().lock();
        try {
            AnalysisResults analysisResults = this.globalContainer.analyze(configuration, issueListener);
            return analysisResults;
        }
        catch (RuntimeException e) {
            throw SonarLintWrappedException.wrap((Throwable)e);
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    private void setLogging(@Nullable LogOutput logOutput) {
        if (logOutput != null) {
            SonarLintLogging.set(logOutput);
        } else {
            SonarLintLogging.set(this.logOutput);
        }
    }

    public void stop() {
        this.setLogging(null);
        this.rwl.writeLock().lock();
        try {
            if (this.globalContainer == null) {
                return;
            }
            this.globalContainer.stopComponents(false);
        }
        catch (RuntimeException e) {
            throw SonarLintWrappedException.wrap((Throwable)e);
        }
        finally {
            this.globalContainer = null;
            this.rwl.writeLock().unlock();
        }
    }
}

